#include<ctype.h>
#include<stdio.h>
#include<stdlib.h>
#include<assert.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/select.h>
#include <curses.h>

#include<curses.h>

// run stty -icanon min 1

static FILE* i_stream = 0;
static FILE* o_stream = 0;
static FILE *odumpfile = 0;
static FILE *idumpfile = 0;

void flush_streams()
{
	fprintf(stdout,"flushing logfiles..");
	fflush(odumpfile);
	fflush(idumpfile);
	fprintf(stdout,"done\n");
}

void setup_files(FILE* i,FILE* o,char *odumpfilename,char *idumpfilename)
{
    if(i==0)
	i_stream = stdin;
    if(o==0)
	o_stream = stdout;

    if (odumpfilename) {
	odumpfile=fopen(odumpfilename,"wb");
	assert(odumpfile);
    }	
    if (idumpfilename) {
        idumpfile=fopen(idumpfilename,"wb");
        assert(idumpfile);
    }



    fcntl(fileno(i_stream),F_SETFL,O_NONBLOCK);
    fcntl(fileno(o_stream),F_SETFL,O_NONBLOCK);

    if(0!=setvbuf(i_stream,0,_IONBF,1))
	perror("io");
    if(0!=setvbuf(o_stream,0,_IONBF,1))
	perror("io");

    system("stty -icanon min 1");
}

unsigned int input()
{
    fd_set r,nix;
    unsigned char c; 
 //   unsigned char b=0x8;
    int fd = fileno(i_stream);
    struct timeval tv;
    int rv;

    FD_ZERO(&r);
    FD_SET(fd, &r);
    FD_ZERO(&nix);


    tv.tv_sec = 10000;
    tv.tv_usec = 0;

    rv = select(fd+1, &r, &nix, &nix, &tv);
    
    if(rv==0)
	perror("io3");
	
    if(read(fd, &c, 1)==0)
    {
	return -1; 
	assert(0);
    }
    if(idumpfile) fputc(c,idumpfile);
   /* switch (c) {
	case 0x7f: fwrite(&b, 1, 1, o_stream);
	   break;
    }
    fprintf(o_stream,"{0x%02x}",c);*/
    return (unsigned int)c;
}


void output(unsigned int i)
{
    unsigned char c = (i&0xff);

    if(1 /*isprint(c)*/)
    {
	fwrite(&c, 1, 1, o_stream);
    }
    else
    {
	fprintf(o_stream,"{0x%02x}",c);
    }
    if(odumpfile) fputc(c,odumpfile);
}

#ifdef kurding
int main()
{
    int c = 1;
    setup_files(0,0);
    while(c!=-1)
    {
	output(c=input());
    }
}
#endif
