/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.authentication;

import com.sshtools.common.authentication.PassphraseDialog;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationPrompt;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class PublicKeyAuthenticationPrompt
implements SshAuthenticationPrompt {
    private Component parent;
    private PublicKeyAuthenticationClient instance;

    public PublicKeyAuthenticationPrompt(Component parent) {
        this.parent = parent;
    }

    public void setInstance(SshAuthenticationClient instance) throws AuthenticationProtocolException {
        if (!(instance instanceof PublicKeyAuthenticationClient)) {
            throw new AuthenticationProtocolException("PublicKeyAuthenticationClient instance required");
        }
        this.instance = (PublicKeyAuthenticationClient)instance;
    }

    public boolean showPrompt(SshAuthenticationClient inst) throws AuthenticationProtocolException {
        SshPrivateKey key;
        File keyfile;
        block14: {
            if (!(inst instanceof PublicKeyAuthenticationClient)) {
                throw new AuthenticationProtocolException("PublicKeyAuthenticationClient instance required");
            }
            this.instance = (PublicKeyAuthenticationClient)inst;
            keyfile = this.instance.getKeyfile() == null ? null : new File(this.instance.getKeyfile());
            String passphrase = null;
            SshPrivateKeyFile pkf = null;
            if (keyfile == null || !keyfile.exists()) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileHidingEnabled(false);
                chooser.setDialogTitle("Select Private Key File For Authentication");
                if (chooser.showOpenDialog(this.parent) == 0) {
                    keyfile = chooser.getSelectedFile();
                } else {
                    return false;
                }
            }
            Object in = null;
            try {
                pkf = SshPrivateKeyFile.parse(keyfile);
            }
            catch (InvalidSshKeyException iske) {
                JOptionPane.showMessageDialog(this.parent, iske.getMessage());
                return false;
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.parent, ioe.getMessage());
            }
            if (pkf.isPassphraseProtected()) {
                Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.parent);
                PassphraseDialog dialog = null;
                dialog = w instanceof Frame ? new PassphraseDialog((Frame)w) : (w instanceof Dialog ? new PassphraseDialog((Dialog)w) : new PassphraseDialog());
                while (true) {
                    dialog.setVisible(true);
                    if (dialog.isCancelled()) {
                        return false;
                    }
                    passphrase = new String(dialog.getPassphrase());
                    try {
                        key = pkf.toPrivateKey(passphrase);
                        break block14;
                    }
                    catch (InvalidSshKeyException ihke) {
                        dialog.setMessage("Passphrase Invalid! Try again");
                        dialog.setMessageForeground(Color.red);
                        continue;
                    }
                    break;
                }
            }
            try {
                key = pkf.toPrivateKey(passphrase);
            }
            catch (InvalidSshKeyException ihke) {
                return false;
            }
        }
        this.instance.setKey(key);
        this.instance.setKeyfile(keyfile.getAbsolutePath());
        return true;
    }
}

