/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SshToolsConnectionProtocolTab
extends JPanel
implements SshToolsConnectionTab {
    static final String KEYS_ICON = "/com/sshtools/common/ui/largekeys.png";
    static final String PROTOCOL_ICON = "/com/sshtools/common/ui/largeprotocol.png";
    static final String DEFAULT = "<Default>";
    protected JComboBox jComboCipherCS = new JComboBox();
    protected JComboBox jComboCipherSC = new JComboBox();
    protected JComboBox jComboMacCS = new JComboBox();
    protected JComboBox jComboMacSC = new JComboBox();
    protected JComboBox jComboCompCS = new JComboBox();
    protected JComboBox jComboCompSC = new JComboBox();
    protected JComboBox jComboKex = new JComboBox();
    protected JComboBox jComboPK = new JComboBox();
    protected SshToolsConnectionProfile profile;

    public SshToolsConnectionProtocolTab() {
        JPanel keysPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(keysPanel, new JLabel("Public key"), gbc, 0);
        gbc.fill = 2;
        UIUtil.jGridBagAdd(keysPanel, this.jComboPK, gbc, 0);
        gbc.fill = 0;
        UIUtil.jGridBagAdd(keysPanel, new JLabel("Key exchange"), gbc, 0);
        gbc.fill = 2;
        UIUtil.jGridBagAdd(keysPanel, this.jComboKex, gbc, 0);
        gbc.fill = 0;
        IconWrapperPanel iconKeysPanel = new IconWrapperPanel(new ResourceIcon(KEYS_ICON), keysPanel);
        JPanel prefPanel = new JPanel(new GridBagLayout());
        prefPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        UIUtil.jGridBagAdd(prefPanel, new JLabel("Client - > Server"), gbc, -1);
        UIUtil.jGridBagAdd(prefPanel, new JLabel("Server - > Client"), gbc, 0);
        gbc.weightx = 2.0;
        UIUtil.jGridBagAdd(prefPanel, new JSeparator(0), gbc, 0);
        UIUtil.jGridBagAdd(prefPanel, new JLabel("Cipher"), gbc, -1);
        UIUtil.jGridBagAdd(prefPanel, new JLabel("Cipher"), gbc, 0);
        UIUtil.jGridBagAdd(prefPanel, this.jComboCipherCS, gbc, -1);
        UIUtil.jGridBagAdd(prefPanel, this.jComboCipherSC, gbc, 0);
        UIUtil.jGridBagAdd(prefPanel, new JLabel("Mac"), gbc, -1);
        UIUtil.jGridBagAdd(prefPanel, new JLabel("Mac"), gbc, 0);
        UIUtil.jGridBagAdd(prefPanel, this.jComboMacCS, gbc, -1);
        UIUtil.jGridBagAdd(prefPanel, this.jComboMacSC, gbc, 0);
        UIUtil.jGridBagAdd(prefPanel, new JLabel("Compression"), gbc, -1);
        UIUtil.jGridBagAdd(prefPanel, new JLabel("Compression"), gbc, 0);
        UIUtil.jGridBagAdd(prefPanel, this.jComboCompCS, gbc, -1);
        UIUtil.jGridBagAdd(prefPanel, this.jComboCompSC, gbc, 0);
        IconWrapperPanel iconPrefPanel = new IconWrapperPanel(new ResourceIcon(PROTOCOL_ICON), prefPanel);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(this, iconKeysPanel, gbc, 0);
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(this, iconPrefPanel, gbc, 0);
        this.loadList(SshCipherFactory.getSupportedCiphers(), this.jComboCipherCS, true);
        this.loadList(SshCipherFactory.getSupportedCiphers(), this.jComboCipherSC, true);
        this.loadList(SshHmacFactory.getSupportedMacs(), this.jComboMacCS, true);
        this.loadList(SshHmacFactory.getSupportedMacs(), this.jComboMacSC, true);
        this.loadList(SshCompressionFactory.getSupportedCompression(), this.jComboCompCS, true);
        this.loadList(SshCompressionFactory.getSupportedCompression(), this.jComboCompSC, true);
        this.loadList(SshKeyExchangeFactory.getSupportedKeyExchanges(), this.jComboKex, true);
        this.loadList(SshKeyPairFactory.getSupportedKeys(), this.jComboPK, true);
    }

    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        this.jComboCipherCS.setSelectedItem(profile.getPrefCSEncryption());
        this.jComboCipherSC.setSelectedItem(profile.getPrefSCEncryption());
        this.jComboMacCS.setSelectedItem(profile.getPrefCSMac());
        this.jComboMacSC.setSelectedItem(profile.getPrefSCMac());
        this.jComboCompCS.setSelectedItem(profile.getPrefCSComp());
        this.jComboCompSC.setSelectedItem(profile.getPrefSCComp());
        this.jComboKex.setSelectedItem(profile.getPrefKex());
        this.jComboPK.setSelectedItem(profile.getPrefPublicKey());
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    private void loadList(List list, JComboBox combo, boolean addDefault) {
        Iterator it = list.iterator();
        if (addDefault) {
            combo.addItem(DEFAULT);
        }
        while (it.hasNext()) {
            combo.addItem(it.next());
        }
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Protocol";
    }

    public String getTabToolTipText() {
        return "Protocol related properties.";
    }

    public int getTabMnemonic() {
        return 112;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        if (!this.jComboCipherCS.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefCSEncryption((String)this.jComboCipherCS.getSelectedItem());
        }
        if (!this.jComboCipherSC.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefSCEncryption((String)this.jComboCipherSC.getSelectedItem());
        }
        if (!this.jComboMacCS.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefCSMac((String)this.jComboMacCS.getSelectedItem());
        }
        if (!this.jComboMacSC.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefSCMac((String)this.jComboMacSC.getSelectedItem());
        }
        if (!this.jComboCompCS.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefCSComp((String)this.jComboCompCS.getSelectedItem());
        }
        if (!this.jComboCompSC.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefSCComp((String)this.jComboCompSC.getSelectedItem());
        }
        if (!this.jComboKex.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefKex((String)this.jComboKex.getSelectedItem());
        }
        if (!this.jComboPK.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefPublicKey((String)this.jComboPK.getSelectedItem());
        }
    }

    public void tabSelected() {
    }
}

