/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

class SshAgentForwardingNotice
extends SubsystemMessage {
    public static final int SSH_AGENT_FORWARDING_NOTICE = 206;
    String remoteHostname;
    String remoteIPAddress;
    UnsignedInteger32 remotePort;

    public SshAgentForwardingNotice() {
        super(206);
    }

    public SshAgentForwardingNotice(String remoteHostname, String remoteIPAddress, int remotePort) {
        super(206);
        this.remoteHostname = remoteHostname;
        this.remoteIPAddress = remoteIPAddress;
        this.remotePort = new UnsignedInteger32(remotePort);
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public String getRemoteIPAddress() {
        return this.remoteIPAddress;
    }

    public int getRemotePort() {
        return this.remotePort.intValue();
    }

    public String getMessageName() {
        return "SSH_AGENT_FORWARDING_NOTICE";
    }

    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeString(this.remoteHostname);
            baw.writeString(this.remoteIPAddress);
            baw.writeUINT32(this.remotePort);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }

    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            this.remoteHostname = bar.readString();
            this.remoteIPAddress = bar.readString();
            this.remotePort = bar.readUINT32();
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }
}

