/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelInputStream;
import com.sshtools.j2ssh.connection.ChannelOutputStream;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessageStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class IOChannel
extends Channel {
    private static Log log = LogFactory.getLog(IOChannel.class);
    private SshMessageStore incoming = new SshMessageStore();
    protected ChannelInputStream in;
    protected ChannelOutputStream out;
    protected InputStream boundInputStream = null;
    protected OutputStream boundOutputStream = null;
    protected IOStreamConnector ios = null;

    protected void init(ConnectionProtocol connection, long localChannelId, long senderChannelId, long initialWindowSize, long maximumPacketSize) throws IOException {
        this.in = new ChannelInputStream(this.incoming);
        this.out = new ChannelOutputStream(this);
        super.init(connection, localChannelId, senderChannelId, initialWindowSize, maximumPacketSize);
    }

    protected void open() throws IOException {
        super.open();
        if (this.boundOutputStream != null) {
            this.sendOutstandingMessages();
        }
        if (this.boundInputStream != null && this.ios == null) {
            this.ios.setCloseInput(false);
            this.ios.setCloseOutput(false);
            this.ios.connect(this.boundInputStream, this.out);
        }
    }

    public ChannelInputStream getInputStream() {
        return this.in;
    }

    public ChannelOutputStream getOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        SshMessageStore sshMessageStore = this.incoming;
        synchronized (sshMessageStore) {
            if (this.boundOutputStream != null) {
                try {
                    this.boundOutputStream.write(msg.getChannelData());
                }
                catch (IOException ex) {
                    log.info("Could not route data to the bound OutputStream; Closing channel.");
                    log.info(ex.getMessage());
                    this.close();
                }
            } else {
                this.incoming.addMessage(msg);
            }
        }
    }

    public void setLocalEOF() throws IOException {
        super.setLocalEOF();
        if (!this.out.isClosed()) {
            this.out.close();
        }
    }

    protected void onChannelEOF() throws IOException {
        if (!this.in.isClosed()) {
            this.in.close();
        }
    }

    protected void onChannelClose() throws IOException {
        if (!this.in.isClosed()) {
            this.in.close();
        }
        if (!this.out.isClosed()) {
            this.out.close();
        }
        if (this.ios != null) {
            this.ios.close();
        }
    }

    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindOutputStream(OutputStream boundOutputStream) throws IOException {
        SshMessageStore sshMessageStore = this.incoming;
        synchronized (sshMessageStore) {
            this.boundOutputStream = boundOutputStream;
            if (this.state.getValue() == 2) {
                this.sendOutstandingMessages();
            }
        }
    }

    public void bindInputStream(InputStream boundInputStream) throws IOException {
        this.boundInputStream = boundInputStream;
        this.ios = new IOStreamConnector();
        if (this.state.getValue() == 2) {
            this.ios.setCloseInput(false);
            this.ios.setCloseOutput(false);
            this.ios.connect(boundInputStream, this.out);
        }
    }

    private void sendOutstandingMessages() throws IOException {
        if (this.boundInputStream != null && this.boundOutputStream != null && this.incoming.hasMessages()) {
            try {
                while (true) {
                    SshMsgChannelData msg = (SshMsgChannelData)this.incoming.peekMessage(94);
                    this.incoming.removeMessage(msg);
                    try {
                        this.boundOutputStream.write(msg.getChannelData());
                    }
                    catch (IOException ex1) {
                        this.close();
                    }
                }
            }
            catch (MessageStoreEOFException ex) {
            }
            catch (MessageNotAvailableException ex) {
            }
            catch (InterruptedException ex) {
                throw new IOException("The thread was interrupted");
            }
        }
    }
}

