/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.net;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class HttpHeader {
    protected static final String white_SPACE = " \t\r";
    HashMap fields = new HashMap();
    protected String begin;

    protected HttpHeader() {
    }

    protected String readLine(InputStream in) throws IOException {
        StringBuffer lineBuf = new StringBuffer();
        while (true) {
            int c;
            if ((c = in.read()) == -1) {
                throw new IOException("Failed to read expected HTTP header line");
            }
            if (c == 10) continue;
            if (c == 13) break;
            lineBuf.append((char)c);
        }
        return new String(lineBuf);
    }

    public String getStartLine() {
        return this.begin;
    }

    public Map getHeaderFields() {
        return this.fields;
    }

    public Set getHeaderFieldNames() {
        return this.fields.keySet();
    }

    public String getHeaderField(String headerName) {
        return (String)this.fields.get(headerName.toLowerCase());
    }

    public void setHeaderField(String headerName, String value) {
        this.fields.put(headerName.toLowerCase(), value);
    }

    public String toString() {
        String str = String.valueOf(this.begin) + "\r\n";
        for (String fieldName : this.getHeaderFieldNames()) {
            str = String.valueOf(str) + fieldName + ": " + this.getHeaderField(fieldName) + "\r\n";
        }
        str = String.valueOf(str) + "\r\n";
        return str;
    }

    protected void processHeaderFields(InputStream in) throws IOException {
        int c;
        this.fields = new HashMap();
        StringBuffer lineBuf = new StringBuffer();
        String lastHeaderName = null;
        while (true) {
            if ((c = in.read()) == -1) {
                throw new IOException("The HTTP header is corrupt");
            }
            if (c == 10) continue;
            if (c != 13) {
                lineBuf.append((char)c);
                continue;
            }
            if (lineBuf.length() == 0) break;
            String line = lineBuf.toString();
            lastHeaderName = this.processNextLine(line, lastHeaderName);
            lineBuf.setLength(0);
        }
        c = in.read();
    }

    private String processNextLine(String line, String lastHeaderName) throws IOException {
        String value;
        String name;
        char c = line.charAt(0);
        if (c == ' ' || c == '\t') {
            name = lastHeaderName;
            value = String.valueOf(this.getHeaderField(lastHeaderName)) + " " + line.trim();
        } else {
            int n = line.indexOf(58);
            if (n == -1) {
                throw new IOException("HTTP Header encoutered a corrupt field: '" + line + "'");
            }
            name = line.substring(0, n).toLowerCase();
            value = line.substring(n + 1).trim();
        }
        this.setHeaderField(name, value);
        return name;
    }
}

