/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.pane;

import edu.harvard.mgh.purcell.gCLINE.PopUpMenu;
import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public abstract class FolderView {
    private static Logger logger = Logger.getLogger(FolderView.class);
    public static String FILE_DISC_SEPERATOR = ":";
    private Record data;
    private StartFrame frame;
    private JList list;
    private MouseListener launchPopup = new MouseListener(){

        public void mousePressed(MouseEvent e) {
            logger.info("[treeEvent.checkEvent(MouseEvent)] mousePressed!");
            this.checkEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            logger.info("[treeEvent.checkEvent(MouseEvent)] mousePressed!");
            this.checkEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private void checkEvent(MouseEvent e) {
            logger.info("[treeEvents.checkEvent(MouseEvent)] entering");
            if (e.isPopupTrigger()) {
                logger.info("[treeEvents.checkEvent(MouseEvent)] PopUp triggered");
                Object[] temp = FolderView.this.list.getSelectedValues();
                String[] selectFiles = new String[temp.length];
                int i = 0;
                while (i < temp.length) {
                    selectFiles[i] = FolderView.this.getFilename(temp[i].toString());
                    ++i;
                }
                FolderView.this.createPopUp(FolderView.this.frame, FolderView.this.data, selectFiles, null).show(e.getComponent(), e.getX(), e.getY());
            } else {
                logger.info("[treeEvents.checkEvent(MouseEvent)] event not triggered");
            }
        }
    };

    private String getFilename(String fileDisc) {
        String[] temp = fileDisc.split(":");
        return temp[0];
    }

    public FolderView(StartFrame f, Record d) {
        this.data = d;
        this.frame = f;
        this.list = new JList(new DefaultListModel());
        EventQueue.invokeLater(new UpdateJList(false));
        this.list.setSelectionMode(2);
        this.list.addMouseListener(this.launchPopup);
        this.list.setDragEnabled(true);
    }

    public JScrollPane toJScrollPane() {
        JScrollPane ans = new JScrollPane(this.list);
        if (this.data != null) {
            ans.setBorder(new TitledBorder("Folder viewer: " + FileInfo.fileName(this.data.getHomeFolder())));
        } else {
            ans.setBorder(new TitledBorder("Folder viewer"));
        }
        return ans;
    }

    protected abstract PopUpMenu createPopUp(StartFrame var1, Record var2, String[] var3, String[] var4);

    public class UpdateJList
    implements Runnable {
        boolean force = false;

        public UpdateJList(boolean given_force) {
            this.force = given_force;
        }

        public void run() {
            logger.info("[run()@UpdateJList] Entering");
            Vector<String> fileList = FolderView.this.data.getHomeFiles();
            DefaultListModel listModel = (DefaultListModel)FolderView.this.list.getModel();
            if (this.force || fileList.size() != listModel.size()) {
                logger.info("[run()@UpdateJList] removing elements");
                listModel.clear();
                logger.info("[run()@UpdateJList] adding " + fileList.size() + " new files");
                logger.info("[run()@UpdateJList] checking the size of the listModel " + listModel.getSize());
                for (String filename : fileList) {
                    String disc = FolderView.this.data.getGlobalNote(filename);
                    if (disc != null && !disc.matches("^\\s*$")) {
                        listModel.addElement(String.valueOf(filename) + FILE_DISC_SEPERATOR + " " + disc);
                        continue;
                    }
                    listModel.addElement(filename);
                }
                logger.info("[run()@UpdateJList] checking the size of the listModel " + listModel.getSize());
            }
            logger.info("[run()@UpdateJList] ...exiting");
        }
    }
}

